/*
 * FetchUntranslated.java
 *
 * Created on 19. august 2000, 20:32
 */

package org.mozilla.translator.fetch;

import org.mozilla.translator.datamodel.*;
import org.mozilla.translator.kernel.*;


/**
 *
 * @author  Henrik Lynggaard
 * @version 
 */
public class FetchUntranslated implements  Fetcher 
{

    private String localeName;
    
    /** Creates new FetchUntranslated */
    public FetchUntranslated(String ln) 
    {
        localeName = ln;
    }

    public boolean check(Phrase ph) 
    {
        boolean result;
        Translation currentTranslation;
        boolean ignoreKeys = Settings.getBoolean("unstranslated.ignorekeys",false);
        
        
        currentTranslation = (Translation) ph.getChildByName(localeName);
        
        if ((currentTranslation==null) && (ph.getKeepOriginal()==false))
        {
            if (ignoreKeys)
            {
                if (ph.getName().endsWith(".accesskey") || ph.getName().endsWith(".commandkey"))
                {
                    result=false;
                }
                else
                {
                    result=true;
                }
            }
            else
            {
                result=true;
            }
        }
        else
        {
            result=false;
        }
        return result;                
    }
}