/*
 * AboutDialog.java
 *
 * Created on 7. september 2000, 22:55
 */

package org.mozilla.translator.gui.dialog;

import org.mozilla.translator.kernel.*;
import org.mozilla.translator.gui.*;

/**
 *
 * @author  Henrik Lynggaard
 * @version 4.15
 */
public class AboutDialog extends javax.swing.JDialog {

    /** Creates new form AboutDialog */
    public AboutDialog() {
        super(MainWindow.getDefaultInstance(),"MozillaTRanslator version " + Settings.getString("System.Version","unknown"),true);
        initComponents ();
        pack ();
        Utils.placeFrameAtCenter(this);

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        okPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        tabPanel = new javax.swing.JTabbedPane();
        generelPanel = new javax.swing.JPanel();
        generelArea = new javax.swing.JTextArea();
        licencePanel = new javax.swing.JPanel();
        licenceArea = new javax.swing.JTextArea();
        postcardPanel = new javax.swing.JPanel();
        addressArea = new javax.swing.JTextArea();
        String dialogTitle = "MozillaTranslator version 4.15";
        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        }
        );
        
        
        okButton.setToolTipText("Close this dialog");
          okButton.setText("Ok");
          okButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  okButtonPressed(evt);
              }
          }
          );
          okPanel.add(okButton);
          
          
        getContentPane().add(okPanel, java.awt.BorderLayout.SOUTH);
        
        
        tabPanel.setFont(new java.awt.Font ("Dialog", 0, 12));
        
        generelPanel.setLayout(new java.awt.BorderLayout());
          
          generelArea.setDisabledTextColor(java.awt.Color.black);
            generelArea.setEditable(false);
            generelArea.setColumns(20);
            generelArea.setFont(new java.awt.Font ("Monospaced", 0, 12));
            generelArea.setText("     MozillaTranslator\n\na localization tool for Mozilla\nand other XUL based programs.\n\nOriginal code by:\nHenrik Lynggaard\nDenmark\n");
            generelArea.setBackground(java.awt.Color.lightGray);
            generelPanel.add(generelArea, java.awt.BorderLayout.CENTER);
            
            tabPanel.addTab("Generel", null, generelPanel, "generel about");
          
          
        licencePanel.setLayout(new java.awt.BorderLayout());
          
          licenceArea.setEditable(false);
            licenceArea.setText("MozillaTranslator is released under MPL \nand PostCardWare\n\nMPL (Mozilla Public Licence 1.1)\nhttp://www.mozilla.org\n\nPostCardWare:\nIf you like this program,\nyou are encuraged to send a postcard\n(snail mail) to the author.\n");
            licenceArea.setBackground(java.awt.Color.lightGray);
            licencePanel.add(licenceArea, java.awt.BorderLayout.CENTER);
            
            tabPanel.addTab("Licence", null, licencePanel, "Licence Information");
          
          
        postcardPanel.setLayout(new java.awt.BorderLayout());
          
          addressArea.setEditable(false);
            addressArea.setText("Postcards should be sent to:\n\nHenrik Lynggaard\nBakkesvinget 22\nTulstrup\n3400 Hilleroed\nDenmark\n");
            addressArea.setBackground(java.awt.Color.lightGray);
            postcardPanel.add(addressArea, java.awt.BorderLayout.CENTER);
            
            tabPanel.addTab("Address", null, postcardPanel, "Postcard address");
          
          
        getContentPane().add(tabPanel, java.awt.BorderLayout.CENTER);
        
    }//GEN-END:initComponents

  private void okButtonPressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonPressed
        setVisible (false);
        dispose ();
  }//GEN-LAST:event_okButtonPressed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible (false);
        dispose ();
    }//GEN-LAST:event_closeDialog

    public void visDialog()
    {
        setVisible(true);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel okPanel;
    private javax.swing.JButton okButton;
    private javax.swing.JTabbedPane tabPanel;
    private javax.swing.JPanel generelPanel;
    private javax.swing.JTextArea generelArea;
    private javax.swing.JPanel licencePanel;
    private javax.swing.JTextArea licenceArea;
    private javax.swing.JPanel postcardPanel;
    private javax.swing.JTextArea addressArea;
    // End of variables declaration//GEN-END:variables

}
