/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 *  except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/

 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is MozillaTranslator (Mozilla Localization Tool)
 *
 * The Initial Developer of the Original Code is Henrik Lynggaard Hansen
 *
 * Portions created by Henrik Lynggard Hansen are
 * Copyright (C) Henrik Lynggaard Hansen.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Henrik Lynggaard Hansen (Initial Code)
 *
 */
package org.mozilla.translator.gui.dialog;

import javax.swing.*;

import org.mozilla.translator.kernel.*;
import org.mozilla.translator.gui.*;
import org.mozilla.translator.datamodel.*;

/**
 *
 * @author  Henrik Lynggaard Hansen
 * @version
 */
public class InstallAdminDialog extends javax.swing.JDialog {



  /** Creates new form InstallAdmin */
  public InstallAdminDialog(java.awt.Frame parent) {
    super (parent,"Install configuration", true);
    initComponents ();
    getRootPane().setDefaultButton(exitButton);
    pack ();
    Utils.placeFrameAtCenter(this);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
private void initComponents () {//GEN-BEGIN:initComponents
    exitButton = new javax.swing.JButton ();
    listPanel = new javax.swing.JPanel ();
    listScroll = new javax.swing.JScrollPane ();
    installList = new javax.swing.JList ();
    addButton = new javax.swing.JButton ();
    editButton = new javax.swing.JButton ();
    removeButton = new javax.swing.JButton ();
    getContentPane ().setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints1;
    setResizable (false);
    setDefaultCloseOperation (javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    addWindowListener (new java.awt.event.WindowAdapter () {
        public void windowClosing (java.awt.event.WindowEvent evt) {
            closeWindow (evt);
        }
    }
    );

    exitButton.setToolTipText ("Leave the dialogbox");
    exitButton.setText ("Exit");
    exitButton.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
            exitButtonPressed (evt);
        }
    }
    );


    gridBagConstraints1 = new java.awt.GridBagConstraints ();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.gridy = 1;
    gridBagConstraints1.gridwidth = 0;
    gridBagConstraints1.insets = new java.awt.Insets (0, 3, 3, 3);
    getContentPane ().add (exitButton, gridBagConstraints1);

    listPanel.setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints2;
    listPanel.setBorder (new javax.swing.border.TitledBorder(
    new javax.swing.border.EtchedBorder(), "Known installations", 4, 2,
    new java.awt.Font ("Dialog", 0, 10)));

  
        installList.setModel (Glossary.getDefaultInstance());
        installList.setPrototypeCellValue ("netscape 60 Preview Release 10 ");
    
        listScroll.setViewportView (installList);
    
      gridBagConstraints2 = new java.awt.GridBagConstraints ();
      gridBagConstraints2.gridheight = 3;
      gridBagConstraints2.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints2.insets = new java.awt.Insets (3, 3, 3, 3);
      gridBagConstraints2.anchor = java.awt.GridBagConstraints.NORTHWEST;
      listPanel.add (listScroll, gridBagConstraints2);
  
      addButton.setToolTipText ("Add a new Mozilla installation");
      addButton.setText ("Add");
      addButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              addButtonPressed (evt);
          }
      }
      );
  
      gridBagConstraints2 = new java.awt.GridBagConstraints ();
      gridBagConstraints2.gridwidth = 0;
      gridBagConstraints2.insets = new java.awt.Insets (3, 0, 3, 3);
      gridBagConstraints2.anchor = java.awt.GridBagConstraints.NORTHWEST;
      // piaip: We can't add anymore
      // listPanel.add (addButton, gridBagConstraints2);
  
      editButton.setToolTipText ("Edit the selected Mozilla installation");
      editButton.setText ("Edit");
      editButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              editButtonPressed (evt);
          }
      }
      );
  
      gridBagConstraints2 = new java.awt.GridBagConstraints ();
      gridBagConstraints2.gridx = 1;
      gridBagConstraints2.gridy = 1;
      gridBagConstraints2.gridwidth = 0;
      gridBagConstraints2.insets = new java.awt.Insets (0, 0, 3, 3);
      gridBagConstraints2.anchor = java.awt.GridBagConstraints.NORTHWEST;
      listPanel.add (editButton, gridBagConstraints2);
  
      removeButton.setToolTipText ("Remove the selected Mozilla installation");
      removeButton.setText ("Remove");
      removeButton.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
              removeButtonPressed (evt);
          }
      }
      );
  
      gridBagConstraints2 = new java.awt.GridBagConstraints ();
      gridBagConstraints2.gridx = 1;
      gridBagConstraints2.gridy = 2;
      gridBagConstraints2.gridwidth = 0;
      gridBagConstraints2.insets = new java.awt.Insets (0, 0, 3, 3);
      gridBagConstraints2.anchor = java.awt.GridBagConstraints.NORTHWEST;
      // piaip: We can't remove anymore
      // listPanel.add (removeButton, gridBagConstraints2);
  

    gridBagConstraints1 = new java.awt.GridBagConstraints ();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.gridy = 0;
    gridBagConstraints1.gridwidth = 0;
    gridBagConstraints1.insets = new java.awt.Insets (3, 3, 3, 3);
    getContentPane ().add (listPanel, gridBagConstraints1);

}//GEN-END:initComponents

  private void closeWindow (java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeWindow
    setVisible(false);
    dispose();
  }//GEN-LAST:event_closeWindow

  private void exitButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitButtonPressed
    setVisible(false);
    dispose();
  }//GEN-LAST:event_exitButtonPressed

  private void removeButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonPressed
    MozInstall install = (MozInstall) installList.getSelectedValue();
    int result;

    result = JOptionPane.showConfirmDialog(removeButton,"Really remove: " + install,"Remove Installation",JOptionPane.OK_CANCEL_OPTION,JOptionPane.WARNING_MESSAGE);

    if (result==JOptionPane.OK_OPTION)
    {
      Glossary.getDefaultInstance().removeChild(install);
      Glossary.getDefaultInstance().fireContentsChanged();
    }
  }//GEN-LAST:event_removeButtonPressed

  private void editButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editButtonPressed
    boolean junk;
    MozInstall install = (MozInstall) installList.getSelectedValue();
    EditInstallDialog eid= new EditInstallDialog(MainWindow.getDefaultInstance(),install);

    if (eid.visDialog())
    {
      Glossary.getDefaultInstance().fireContentsChanged();
    }
  }//GEN-LAST:event_editButtonPressed

  private void addButtonPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonPressed

    MozInstall install = new MozInstall("","");
    EditInstallDialog eid = new EditInstallDialog(MainWindow.getDefaultInstance(),install);

    if (eid.visDialog())
    {
      Glossary.getDefaultInstance().addChild(install);
      Glossary.getDefaultInstance().fireContentsChanged();
    }
  }//GEN-LAST:event_addButtonPressed

  /** Closes the dialog */
// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JButton exitButton;
private javax.swing.JPanel listPanel;
private javax.swing.JScrollPane listScroll;
private javax.swing.JList installList;
private javax.swing.JButton addButton;
private javax.swing.JButton editButton;
private javax.swing.JButton removeButton;
// End of variables declaration//GEN-END:variables

}
