/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 *  except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/

 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is MozillaTranslator (Mozilla Localization Tool)
 *
 * The Initial Developer of the Original Code is Henrik Lynggaard Hansen
 *
 * Portions created by Henrik Lynggard Hansen are
 * Copyright (C) Henrik Lynggaard Hansen.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Henrik Lynggaard Hansen (Initial Code)
 *
 */
package org.mozilla.translator.gui.dialog;

import org.mozilla.translator.kernel.*;


/** 
 *
 * @author  Henrik Lynggaard
 * @version 3.4
*/
public class SearchDialog extends javax.swing.JDialog {
  
  private String searchText;
  private String localeName;
  private String selectedColumn;
  private String selectedRule;
  private boolean selectedCase;
  private boolean okay;

  
  /** Creates new form SearchDialog */
  public SearchDialog(java.awt.Frame parent,boolean modal) {
    super (parent, "Search",modal);
    initComponents ();
    getRootPane().setDefaultButton(okButton);
    pack ();
    Utils.placeFrameAtCenter(this);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents() {//GEN-BEGIN:initComponents
      searchLabel = new javax.swing.JLabel();
      searchField = new javax.swing.JTextField();
      WhereLabel = new javax.swing.JLabel();
      columnCombo = new javax.swing.JComboBox();
      ruleCombo = new javax.swing.JComboBox();
      localeLabel = new javax.swing.JLabel();
      localeField = new javax.swing.JTextField();
      okButton = new javax.swing.JButton();
      cancelButton = new javax.swing.JButton();
      howLabel = new javax.swing.JLabel();
      caseCheck = new javax.swing.JCheckBox();
      getContentPane().setLayout(new java.awt.GridBagLayout());
      java.awt.GridBagConstraints gridBagConstraints1;
      
      searchLabel.setText("Search for ");
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.insets = new java.awt.Insets(3, 0, 0, 0);
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      getContentPane().add(searchLabel, gridBagConstraints1);
      
      
      searchField.setText("x");
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridwidth = 0;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.insets = new java.awt.Insets(3, 3, 0, 0);
      getContentPane().add(searchField, gridBagConstraints1);
      
      
      WhereLabel.setText("Where");
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridx = 0;
      gridBagConstraints1.gridy = 1;
      gridBagConstraints1.insets = new java.awt.Insets(3, 0, 0, 0);
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      getContentPane().add(WhereLabel, gridBagConstraints1);
      
      
      columnCombo.addItem("Key");
      columnCombo.addItem("Localization note");
      columnCombo.addItem("Original text");
      columnCombo.addItem("Translated text");
      columnCombo.addItem("QA comment");
      
      
      
      
      
      
      
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 1;
      gridBagConstraints1.gridwidth = 0;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.insets = new java.awt.Insets(3, 3, 0, 0);
      getContentPane().add(columnCombo, gridBagConstraints1);
      
      
      ruleCombo.addItem("Is");
      ruleCombo.addItem("Is not");
      ruleCombo.addItem("Contains");
      ruleCombo.addItem("Doesn't contain");
      ruleCombo.addItem("Starts with");
      ruleCombo.addItem("Ends with");
      
      
      
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 2;
      gridBagConstraints1.gridwidth = 0;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.insets = new java.awt.Insets(3, 3, 0, 0);
      getContentPane().add(ruleCombo, gridBagConstraints1);
      
      
      localeLabel.setText("Locale");
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridx = 0;
      gridBagConstraints1.gridy = 3;
      gridBagConstraints1.insets = new java.awt.Insets(3, 0, 0, 0);
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      getContentPane().add(localeLabel, gridBagConstraints1);
      
      
      localeField.setText("da-DK");
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 3;
      gridBagConstraints1.gridwidth = 0;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.insets = new java.awt.Insets(3, 3, 0, 0);
      getContentPane().add(localeField, gridBagConstraints1);
      
      
      okButton.setText("OK");
      okButton.addActionListener(new java.awt.event.ActionListener() {
          public void actionPerformed(java.awt.event.ActionEvent evt) {
              okPressed(evt);
          }
      }
      );
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridx = 0;
      gridBagConstraints1.gridy = 5;
      gridBagConstraints1.insets = new java.awt.Insets(3, 0, 0, 0);
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
      getContentPane().add(okButton, gridBagConstraints1);
      
      
      cancelButton.setText("Cancel");
      cancelButton.addActionListener(new java.awt.event.ActionListener() {
          public void actionPerformed(java.awt.event.ActionEvent evt) {
              cancelPressed(evt);
          }
      }
      );
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 5;
      gridBagConstraints1.gridwidth = 0;
      gridBagConstraints1.insets = new java.awt.Insets(3, 2, 0, 0);
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      getContentPane().add(cancelButton, gridBagConstraints1);
      
      
      howLabel.setText("how");
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridx = 0;
      gridBagConstraints1.gridy = 2;
      gridBagConstraints1.insets = new java.awt.Insets(3, 0, 0, 0);
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      getContentPane().add(howLabel, gridBagConstraints1);
      
      
      caseCheck.setSelected(true);
      caseCheck.setText("Casesensitive");
      
      gridBagConstraints1 = new java.awt.GridBagConstraints();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 4;
      gridBagConstraints1.gridwidth = 0;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.insets = new java.awt.Insets(3, 3, 0, 0);
      getContentPane().add(caseCheck, gridBagConstraints1);
      
  }//GEN-END:initComponents

  private void okPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okPressed
  okay=true;
  setVisible(false);
  }//GEN-LAST:event_okPressed

  private void cancelPressed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelPressed
  okay=false;
  setVisible(false); 
  }//GEN-LAST:event_cancelPressed


  public boolean visDialog()
  {
    okay=false;
    localeField.setText(Settings.getString("saved.localeName",""));
    searchField.setText(Settings.getString("saved.search.text",""));
    columnCombo.setSelectedIndex(Settings.getInteger("saved.search.field",0));
    ruleCombo.setSelectedIndex(Settings.getInteger("saved.search.rule",0));
    caseCheck.setSelected(Settings.getBoolean("saved.search.case",false));

    setVisible(true);
    if (okay)
    {
       Settings.setString("saved.localeName",localeField.getText());
       Settings.setString("saved.search.text",searchField.getText());
       Settings.setInteger("saved.search.field",columnCombo.getSelectedIndex());
       Settings.setInteger("saved.search.rule",ruleCombo.getSelectedIndex());
       Settings.setBoolean("saved.search.case",caseCheck.isSelected());    
    }
    searchText = searchField.getText();
    localeName = localeField.getText();
    selectedColumn = columnCombo.getSelectedItem().toString();
    selectedRule = ruleCombo.getSelectedItem().toString();
    selectedCase = caseCheck.isSelected();
    
    dispose();
    return okay;
  }
  
  public String getSearchText() { return searchText; }
  
  public String getLocaleName() { return localeName; }
  
  public String  getColumn() { return selectedColumn;}
  
  public String getRule() { return selectedRule;}
  
public boolean getCase()  { return selectedCase;}
    



// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JLabel searchLabel;
private javax.swing.JTextField searchField;
private javax.swing.JLabel WhereLabel;
private javax.swing.JComboBox columnCombo;
private javax.swing.JComboBox ruleCombo;
private javax.swing.JLabel localeLabel;
private javax.swing.JTextField localeField;
private javax.swing.JButton okButton;
private javax.swing.JButton cancelButton;
private javax.swing.JLabel howLabel;
private javax.swing.JCheckBox caseCheck;
// End of variables declaration//GEN-END:variables

}