/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class MozTreeNode
extends AbstractListModel
implements Comparable {
    protected List children;
    protected String name;
    protected MozTreeNode parent;
    protected boolean marked;

    public MozTreeNode(String n, MozTreeNode p) {
        this.name = n;
        this.parent = p;
        this.children = new ArrayList();
        this.marked = false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MozTreeNode getParent() {
        return this.parent;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean m) {
        this.marked = m;
    }

    public void addChild(MozTreeNode child) {
        this.children.add(child);
    }

    public void removeChild(MozTreeNode child) {
        this.children.remove(child);
    }

    public MozTreeNode getChildByName(String name) {
        return this.getChildByName(name, true);
    }

    public MozTreeNode getChildByName(String name, boolean sensitive) {
        Iterator childIterator = this.children.iterator();
        boolean done = false;
        MozTreeNode result = null;
        while (!done && childIterator.hasNext()) {
            MozTreeNode child = (MozTreeNode)childIterator.next();
            if (sensitive) {
                if (!name.equals(child.getName())) continue;
                done = true;
                result = child;
                continue;
            }
            if (!name.equalsIgnoreCase(child.getName())) continue;
            done = true;
            result = child;
        }
        return result;
    }

    public Iterator getChildIterator() {
        return this.children.iterator();
    }

    public List getAllChildren() {
        return this.children;
    }

    public String toString() {
        return this.name;
    }

    public int getSize() {
        return this.children.size();
    }

    public Object getElementAt(int index) {
        return this.children.get(index);
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.children.size());
    }

    public Object[] toArray() {
        return this.children.toArray();
    }

    public int compareTo(Object pl) {
        MozTreeNode other = (MozTreeNode)pl;
        return this.name.compareTo(other.name);
    }
}

