/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.gui.MozFrame;
import org.mozilla.translator.gui.models.ComplexTableModel;

public class ChromeView
extends JInternalFrame
implements TreeSelectionListener,
MozFrame {
    private List cols;
    private String localeName;
    private ComplexTableModel model;
    private JTree tree;
    private JTable table;
    private DefaultMutableTreeNode root;
    private JScrollPane treeScroll;
    private JScrollPane tableScroll;
    private JSplitPane split;

    public ChromeView(List wCols, String l) {
        super("Chrome view for ".concat(String.valueOf(String.valueOf(l))));
        this.cols = wCols;
        this.localeName = l;
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.setResizable(true);
        MozInstall notLoadedInstall = new MozInstall("not loaded", "not loaded");
        MozComponent notLoadedComponent = new MozComponent("not loaded", notLoadedInstall);
        MozComponent notLoadedSubcomponent = new MozComponent("not loaded", notLoadedComponent);
        MozFile notLoadedFile = new MozFile("not loaded", notLoadedSubcomponent);
        Phrase notLoadedPhrase = new Phrase("not loaded", notLoadedFile, "not loaded", "not loaded", false);
        ArrayList<Phrase> notLoadedList = new ArrayList<Phrase>();
        notLoadedList.add(notLoadedPhrase);
        this.root = Glossary.getDefaultInstance().getTreeRoot();
        this.tree = new JTree(this.root);
        this.tree.addTreeSelectionListener(this);
        this.tree.setRootVisible(false);
        this.treeScroll = new JScrollPane(this.tree);
        this.model = new ComplexTableModel(notLoadedList, this.cols, this.localeName);
        this.table = new JTable(this.model);
        this.tableScroll = new JScrollPane(this.table);
        this.split = new JSplitPane(1, this.treeScroll, this.tableScroll);
        this.getContentPane().add((Component)this.split, "Center");
        this.pack();
        MainWindow.getDefaultInstance().addWindow(this);
        this.split.setOneTouchExpandable(true);
        try {
            this.setMaximum(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.split.setDividerLocation(0.3);
        this.setVisible(true);
    }

    public void valueChanged(TreeSelectionEvent evt) {
        block0: {
            TreePath tp = evt.getNewLeadSelectionPath();
            int pathCount = tp.getPathCount();
            if (pathCount != 5) break block0;
            DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)tp.getLastPathComponent();
            MozFile theFile = (MozFile)lastNode.getUserObject();
            List ps = theFile.getAllChildren();
            this.model = new ComplexTableModel(ps, this.cols, this.localeName);
            this.table.setModel(this.model);
        }
    }

    public Phrase getSelectedPhrase() {
        int rowIndex = this.table.getSelectedRow();
        return this.model.getRow(rowIndex);
    }

    public String getLocaleName() {
        return this.localeName;
    }

    public JTable getTable() {
        return this.table;
    }
}

