/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Settings;
import org.mozilla.translator.kernel.Utils;

public class WriteXpiDialog
extends JDialog {
    private boolean xpi;
    private JPanel infPanel;
    private JLabel fileLabel;
    private JTextField fileField;
    private JButton fileButton;
    private JLabel installLabel;
    private JComboBox installCombo;
    private JLabel localeLabel;
    private JTextField localeField;
    private JLabel authorLabel;
    private JTextField authorField;
    private JLabel displayLabel;
    private JTextField displayField;
    private JLabel displayRegionLabel;
    private JTextField displayRegionField;
    private JLabel previewLabel;
    private JTextField previewField;
    private JLabel versionLabel;
    private JTextField versionField;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okay;

    public WriteXpiDialog(String title, boolean xp) {
        super(MainWindow.getDefaultInstance(), title, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        Utils.placeFrameAtCenter(this);
        this.xpi = xp;
    }

    private void initComponents() {
        this.infPanel = new JPanel();
        this.fileLabel = new JLabel();
        this.fileField = new JTextField();
        this.fileButton = new JButton();
        this.installLabel = new JLabel();
        this.installCombo = new JComboBox<Object>(Glossary.getDefaultInstance().toArray());
        this.localeLabel = new JLabel();
        this.localeField = new JTextField();
        this.authorLabel = new JLabel();
        this.authorField = new JTextField();
        this.displayLabel = new JLabel();
        this.displayRegionLabel = new JLabel();
        this.displayField = new JTextField();
        this.displayRegionField = new JTextField();
        this.previewLabel = new JLabel();
        this.previewField = new JTextField();
        this.versionLabel = new JLabel();
        this.versionField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.infPanel.setLayout(new GridBagLayout());
        this.infPanel.setBorder(new TitledBorder(new EtchedBorder(), "Information", 4, 2, new Font("Dialog", 0, 10)));
        this.fileLabel.setText("Save to");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(3, 0, 0, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.fileLabel, gridBagConstraints2);
        this.fileField.setColumns(20);
        this.fileField.setText("D:\\preo\\fhbndj\\hoigtrod\\glossary.zip");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.fileField, gridBagConstraints2);
        this.fileButton.setText("Choose");
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WriteXpiDialog.this.fileButtonPressed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.fileButton, gridBagConstraints2);
        this.installLabel.setText("Install(nwumr)");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.installLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.installCombo, gridBagConstraints2);
        this.localeLabel.setText("Locale");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(3, 0, 0, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.localeLabel, gridBagConstraints2);
        this.localeField.setColumns(10);
        this.localeField.setText("da-DK");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.localeField, gridBagConstraints2);
        this.authorLabel.setText("Author");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(3, 0, 0, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.authorLabel, gridBagConstraints2);
        this.authorField.setColumns(30);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
        this.infPanel.add((Component)this.authorField, gridBagConstraints2);
        this.displayLabel.setText("Display name");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.displayLabel, gridBagConstraints2);
        this.displayField.setColumns(30);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
        this.infPanel.add((Component)this.displayField, gridBagConstraints2);
        this.displayRegionLabel.setText("Region Display");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.displayRegionLabel, gridBagConstraints2);
        this.displayRegionField.setColumns(30);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
        this.infPanel.add((Component)this.displayRegionField, gridBagConstraints2);
        this.previewLabel.setText("Preview URL");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.previewLabel, gridBagConstraints2);
        this.previewField.setColumns(30);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
        this.infPanel.add((Component)this.previewField, gridBagConstraints2);
        this.versionLabel.setText("*Mozilla Version*");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(3, 0, 0, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.versionLabel, gridBagConstraints2);
        this.versionField.setColumns(30);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
        this.infPanel.add((Component)this.versionField, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.infPanel, gridBagConstraints1);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WriteXpiDialog.this.okButtonPressed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints1.anchor = 13;
        gridBagConstraints1.weightx = 0.5;
        this.getContentPane().add((Component)this.okButton, gridBagConstraints1);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WriteXpiDialog.this.cancelButtonPressed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(0, 0, 3, 3);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.5;
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints1);
    }

    private void fileButtonPressed(ActionEvent evt) {
        File defaultFile = new File(this.fileField.getText());
        JFileChooser dirChooser = new JFileChooser();
        dirChooser.setFileSelectionMode(0);
        dirChooser.setSelectedFile(defaultFile);
        int result = dirChooser.showDialog(this, "Choose");
        if (result == 0) {
            File dir = dirChooser.getSelectedFile();
            this.fileField.setText(dir.toString());
        }
    }

    private void okButtonPressed(ActionEvent evt) {
        this.okay = true;
        ((Component)this).setVisible(false);
    }

    private void cancelButtonPressed(ActionEvent evt) {
        this.okay = false;
        ((Component)this).setVisible(false);
    }

    public boolean visDialog() {
        MozInstall install = (MozInstall)this.installCombo.getSelectedItem();
        if (this.xpi) {
            this.fileField.setText(Settings.getString("saved.xpiFile", ""));
        } else {
            this.fileField.setText(Settings.getString("saved.jarFile", ""));
        }
        this.localeField.setText(Settings.getString("saved.localeName", ""));
        this.authorField.setText(Settings.getString("saved.author", ""));
        this.displayField.setText(Settings.getString("saved.displayName", ""));
        this.displayRegionField.setText(Settings.getString("saved.displayRegionName", ""));
        this.previewField.setText(Settings.getString("saved.previewURL", ""));
        this.versionField.setText(Settings.getString("saved.xpiVersion", ""));
        ((Component)this).setVisible(true);
        if (this.okay) {
            if (this.xpi) {
                Settings.setString("saved.xpiFile", this.fileField.getText());
            } else {
                Settings.setString("saved.jarFile", this.fileField.getText());
            }
            Settings.setString("saved.localeName", this.localeField.getText());
            Settings.setString("saved.author", this.authorField.getText());
            Settings.setString("saved.displayName", this.displayField.getText());
            Settings.setString("saved.displayRegionName", this.displayRegionField.getText());
            Settings.setString("saved.previewURL", this.previewField.getText());
            Settings.setString("saved.xpiVersion", this.versionField.getText());
        }
        return this.okay;
    }

    public String getFile() {
        return this.fileField.getText();
    }

    public MozInstall getInstall() {
        return (MozInstall)this.installCombo.getSelectedItem();
    }

    public String getLocaleName() {
        return this.localeField.getText();
    }

    public String getAuthor() {
        return this.authorField.getText();
    }

    public String getDisplay() {
        return this.displayField.getText();
    }

    public String getDisplayRegion() {
        return this.displayRegionField.getText();
    }

    public String getPreview() {
        return this.previewField.getText();
    }

    public String getVersion() {
        return this.versionField.getText();
    }
}

