/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.kernel;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.mozilla.translator.kernel.DefaultSettings;
import org.mozilla.translator.kernel.Log;

public class Settings {
    private static Properties prop;
    private static String fileName;

    public static void init(String fn) {
        fileName = fn;
        DefaultSettings def = new DefaultSettings();
        prop = new Properties(def.getDefaults());
        try {
            FileInputStream fis = new FileInputStream(fileName);
            prop.load(fis);
            fis.close();
        }
        catch (Exception exception) {}
    }

    public static void setString(String key, String value) {
        prop.setProperty(key, value);
    }

    public static void setBoolean(String key, boolean value) {
        String strValue = String.valueOf(value);
        prop.setProperty(key, strValue);
    }

    public static void setInteger(String key, int value) {
        String strValue = Integer.toString(value);
        prop.setProperty(key, strValue);
    }

    public static String getString(String key, String defValue) {
        return prop.getProperty(key, defValue);
    }

    public static boolean getBoolean(String key, boolean defValue) {
        String tempResult = prop.getProperty(key, String.valueOf(defValue));
        boolean result = Boolean.valueOf(tempResult);
        return result;
    }

    public static int getInteger(String key, int defValue) {
        String tempResult = prop.getProperty(key, String.valueOf(defValue));
        return Integer.parseInt(tempResult);
    }

    public static void save() {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            prop.store(fos, "Settings for mozillaTranslator");
            fos.close();
        }
        catch (Exception e) {
            Log.write("Error saving property file");
        }
    }
}

