/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.runners;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Log;

public class ExportTextRunner
extends Thread {
    MozInstall install;
    String fileName;
    String localeName;

    public ExportTextRunner(MozInstall i, String fn, String ln) {
        this.install = i;
        this.fileName = fn;
        this.localeName = ln;
    }

    public void run() {
        MainWindow.getDefaultInstance().setStatus("Writeing text file...");
        try {
            FileOutputStream fos = new FileOutputStream(this.fileName, false);
            PrintWriter pw = new PrintWriter(fos);
            Iterator componentIterator = this.install.getChildIterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                Iterator subcomponentIterator = currentComponent.getChildIterator();
                while (subcomponentIterator.hasNext()) {
                    MozComponent currentSubcomponent = (MozComponent)subcomponentIterator.next();
                    Iterator fileIterator = currentSubcomponent.getChildIterator();
                    while (fileIterator.hasNext()) {
                        MozFile currentFile = (MozFile)fileIterator.next();
                        Iterator phraseIterator = currentFile.getChildIterator();
                        while (phraseIterator.hasNext()) {
                            Phrase currentPhrase = (Phrase)phraseIterator.next();
                            Translation currentTranslation = (Translation)currentPhrase.getChildByName(this.localeName);
                            if (currentTranslation == null || currentTranslation.getText().length() <= 1) continue;
                            pw.println(currentTranslation.getText());
                        }
                    }
                }
            }
            pw.close();
            MainWindow.getDefaultInstance().setStatus("Ready");
        }
        catch (Exception e) {
            Log.write("Error in writing text file");
            Log.write("Exception ".concat(String.valueOf(String.valueOf(e))));
        }
    }
}

