/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.runners;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Log;
import org.mozilla.translator.runners.WriteJarRunner;

public class WriteXpiRunner
extends Thread {
    private MozInstall install;
    private String fileName;
    private String localeName;
    private String langcode;
    private String regioncode;
    private String author;
    private String display;
    private String displayRegion;
    private String preview;
    private String version;
    private File zipFile;
    private FileOutputStream fos;
    private ZipOutputStream zos;
    private BufferedOutputStream bos;
    private String entryName;

    public WriteXpiRunner(MozInstall i, String fn, String ln, String a, String d, String dr, String p, String v) {
        this.fileName = fn;
        this.localeName = ln;
        int dashindex = this.localeName.indexOf(45);
        this.langcode = this.localeName.substring(0, dashindex);
        this.regioncode = this.localeName.substring(dashindex + 1);
        this.author = a;
        this.display = d;
        this.displayRegion = dr;
        this.preview = p;
        this.version = v;
    }

    public void run() {
        MainWindow vindue = MainWindow.getDefaultInstance();
        try {
            this.zipFile = new File(this.fileName);
            this.fos = new FileOutputStream(this.zipFile);
            this.zos = new ZipOutputStream(this.fos);
            this.bos = new BufferedOutputStream(this.zos);
            String jarString = "MT_tempjar";
            Iterator iterator = Glossary.getDefaultInstance().getChildIterator();
            this.install = (MozInstall)iterator.next();
            Log.write("Writing Natual");
            WriteJarRunner wjr = new WriteJarRunner(this.install, jarString, this.localeName, this.author, this.display, this.displayRegion, this.preview, this.version);
            wjr.start();
            wjr.join();
            File jarFile = new File(jarString);
            this.copyFile(jarFile, String.valueOf(String.valueOf(new StringBuffer("bin/chrome/").append(this.localeName).append(".jar"))));
            this.bos.flush();
            jarFile.delete();
            Log.write("Writing en-win");
            this.install = (MozInstall)iterator.next();
            wjr = new WriteJarRunner(this.install, jarString, this.localeName, this.author, this.display, this.displayRegion, this.preview, this.version);
            wjr.start();
            wjr.join();
            jarFile = new File(jarString);
            this.copyFile(jarFile, String.valueOf(String.valueOf(new StringBuffer("bin/chrome/").append(this.langcode).append("-win").append(".jar"))));
            this.bos.flush();
            jarFile.delete();
            Log.write("Writing en-unix");
            this.install = (MozInstall)iterator.next();
            wjr = new WriteJarRunner(this.install, jarString, this.localeName, this.author, this.display, this.displayRegion, this.preview, this.version);
            wjr.start();
            wjr.join();
            jarFile = new File(jarString);
            this.copyFile(jarFile, String.valueOf(String.valueOf(new StringBuffer("bin/chrome/").append(this.langcode).append("-unix").append(".jar"))));
            this.bos.flush();
            jarFile.delete();
            Log.write("Writing en-mac");
            this.install = (MozInstall)iterator.next();
            wjr = new WriteJarRunner(this.install, jarString, this.localeName, this.author, this.display, this.displayRegion, this.preview, this.version);
            wjr.start();
            wjr.join();
            jarFile = new File(jarString);
            this.copyFile(jarFile, String.valueOf(String.valueOf(new StringBuffer("bin/chrome/").append(this.langcode).append("-mac").append(".jar"))));
            this.bos.flush();
            jarFile.delete();
            Log.write("Writing us");
            this.install = (MozInstall)iterator.next();
            wjr = new WriteJarRunner(this.install, jarString, this.localeName, this.author, this.display, this.displayRegion, this.preview, this.version);
            wjr.start();
            wjr.join();
            jarFile = new File(jarString);
            this.copyFile(jarFile, String.valueOf(String.valueOf(new StringBuffer("bin/chrome/").append(this.regioncode).append(".jar"))));
            this.bos.flush();
            jarFile.delete();
            this.writeInstallScript();
            this.bos.close();
        }
        catch (Exception e) {
            Log.write("Error writing jar file to xpi");
            Log.write("Exception: ".concat(String.valueOf(String.valueOf(e))));
        }
        MainWindow.getDefaultInstance().setStatus("Ready");
    }

    private void writeInstallScript() {
        try {
            File fil = File.createTempFile("MT_", null);
            FileWriter fw = new FileWriter(fil);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("// this function verifies disk space in kilobytes");
            pw.println("function verifyDiskSpace(dirPath, spaceRequired)");
            pw.println("{");
            pw.println("  var spaceAvailable;");
            pw.println("");
            pw.println("  // Get the available disk space on the given path");
            pw.println("  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);");
            pw.println("");
            pw.println("  // Convert the available disk space into kilobytes");
            pw.println("  spaceAvailable = parseInt(spaceAvailable / 1024);");
            pw.println("");
            pw.println("  // do the verification");
            pw.println("  if(spaceAvailable < spaceRequired)");
            pw.println("  {");
            pw.println("    logComment(\"Insufficient disk space: \" + dirPath);");
            pw.println("    logComment(\"  required : \" + spaceRequired + \" K\");");
            pw.println("    logComment(\"  available: \" + spaceAvailable + \" K\");");
            pw.println("    return(false);");
            pw.println("  }");
            pw.println("");
            pw.println("  return(true);");
            pw.println("}");
            pw.println("");
            pw.println("// OS type detection");
            pw.println("// which platform?");
            pw.println("function getPlatform()");
            pw.println("{");
            pw.println("  var platformStr;");
            pw.println("  var platformNode;");
            pw.println("");
            pw.println("  if('platform' in Install)");
            pw.println("  {");
            pw.println("    platformStr = new String(Install.platform);");
            pw.println("");
            pw.println("    if (!platformStr.search(/^Macintosh/))");
            pw.println("      platformNode = 'mac';");
            pw.println("    else if (!platformStr.search(/^Win/))");
            pw.println("      platformNode = 'win';");
            pw.println("    else");
            pw.println("      platformNode = 'unix';");
            pw.println("  }");
            pw.println("  else");
            pw.println("  {");
            pw.println("    var fOSMac  = getFolder(\"Mac System\");");
            pw.println("    var fOSWin  = getFolder(\"Win System\");");
            pw.println("");
            pw.println("    logComment(\"fOSMac: \"  + fOSMac);");
            pw.println("    logComment(\"fOSWin: \"  + fOSWin);");
            pw.println("");
            pw.println("    if(fOSMac != null)");
            pw.println("      platformNode = 'mac';");
            pw.println("    else if(fOSWin != null)");
            pw.println("      platformNode = 'win';");
            pw.println("    else");
            pw.println("      platformNode = 'unix';");
            pw.println("  }");
            pw.println("");
            pw.println("  return platformNode;");
            pw.println("}");
            pw.println("");
            pw.println("");
            pw.println("var srDest = 500;");
            pw.println("var err;");
            pw.println("var fProgram;");
            pw.println("var platformNode;");
            pw.println("");
            pw.println("platformNode = getPlatform();");
            pw.println("logComment(\"initInstall: platformNode=\" + platformNode);");
            pw.println("// end - OS type detection");
            pw.println("");
            pw.println("// --- LOCALIZATION NOTE: translate only these ---");
            pw.println(String.valueOf(String.valueOf(new StringBuffer("var prettyName = \"").append(this.display).append("\";"))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("var langcode = \"").append(this.langcode).append("\";"))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("var regioncode = \"").append(this.regioncode).append("\";"))));
            pw.println("var chromeNode = langcode + \"-\" + regioncode;");
            pw.println("// --- END LOCALIZABLE RESOURCES ---");
            pw.println("var regName    = \"locales/mozilla/\" + chromeNode;");
            pw.println("var chromeName = chromeNode + \".jar\";");
            pw.println("var regionFile = regioncode + \".jar\";");
            pw.println("var platformName = langcode + \"-\" + platformNode + \".jar\";");
            pw.println("var localeName = \"locale/\" + chromeNode + \"/\";");
            pw.println("var regionName = \"locale/\" + regioncode + \"/\";");
            pw.println("");
            pw.println("err = initInstall(prettyName, regName, \"0.9.9\"); ");
            pw.println("logComment(\"initInstall: \" + err);");
            pw.println("");
            pw.println("fProgram = getFolder(\"Program\");");
            pw.println("logComment(\"fProgram: \" + fProgram);");
            pw.println("");
            pw.println("if (verifyDiskSpace(fProgram, srDest))");
            pw.println("{");
            pw.println("    var chromeType = LOCALE | DELAYED_CHROME;");
            pw.println("    err = addDirectory(\"\",\"bin\",fProgram,\"\");");
            pw.println("    logComment(\"addDirectory() returned: \" + err);");
            pw.println("");
            pw.println("    if (err != SUCCESS)");
            pw.println("    {");
            pw.println("        logComment(\"addDirectory() to \" + fProgram + \"failed!\");");
            pw.println(" ");
            pw.println("        // couldn't install globally, try installing to the profile");
            pw.println("");
            pw.println("// seems not to be working with DELAYED_CHROME !?");
            pw.println("//        resetError();");
            pw.println("//        chromeType |= PROFILE_CHROME;");
            pw.println("//        fProgram = getFolder(\"Profile\");");
            pw.println("//        logComment(\"try installing to the user profile:\" + fProgram);");
            pw.println("//        err = addDirectory(\"\",\"bin/chrome\",fProgram,\"chrome\");");
            pw.println("    }");
            pw.println(" ");
            pw.println("    setPackageFolder(fProgram);");
            pw.println(" ");
            pw.println("    // check return value");
            pw.println("    if (err == SUCCESS)");
            pw.println("    {");
            pw.println("        // register chrome");
            pw.println("        var cf = getFolder(fProgram, \"chrome/\"+chromeName);");
            pw.println("        var pf = getFolder(fProgram, \"chrome/\"+platformName);");
            pw.println("        var rf = getFolder(fProgram, \"chrome/\"+regionFile);");
            pw.println("");
            pw.println("        registerChrome(chromeType, cf, localeName + \"global/\");");
            pw.println("        registerChrome(chromeType, cf, localeName + \"communicator/\");");
            pw.println("");
            pw.println("        registerChrome(chromeType, cf, localeName + \"messenger/\");");
            pw.println("        registerChrome(chromeType, cf, localeName + \"editor/\");");
            pw.println("        registerChrome(chromeType, cf, localeName + \"navigator/\");");
            pw.println("        registerChrome(chromeType, cf, localeName + \"necko/\");");
            pw.println("        registerChrome(chromeType, cf, localeName + \"cookie/\");");
            pw.println("        registerChrome(chromeType, cf, localeName + \"wallet/\");");
            pw.println("        registerChrome(chromeType, cf, localeName + \"content-packs/\");");
            pw.println("        registerChrome(chromeType, cf, localeName + \"help/\");");
            pw.println("        registerChrome(chromeType, cf, localeName + \"pipnss/\");");
            pw.println("        registerChrome(chromeType, cf, localeName + \"pippki/\");");
            pw.println("");
            pw.println("        registerChrome(chromeType, pf, localeName + \"global-platform/\");");
            pw.println("        registerChrome(chromeType, pf, localeName + \"communicator-platform/\");");
            pw.println("        registerChrome(chromeType, pf, localeName + \"navigator-platform/\");");
            pw.println("");
            pw.println("        registerChrome(chromeType, rf, regionName + \"global-region/\");");
            pw.println("        registerChrome(chromeType, rf, regionName + \"communicator-region/\");");
            pw.println("        registerChrome(chromeType, rf, regionName + \"editor-region/\");");
            pw.println("        registerChrome(chromeType, rf, regionName + \"messenger-region/\");");
            pw.println("        registerChrome(chromeType, rf, regionName + \"navigator-region/\");");
            pw.println("        err = performInstall(); ");
            pw.println("        logComment(\"performInstall() returned: \" + err);");
            pw.println("        if (err == SUCCESS)");
            pw.println("        {");
            pw.println("            alert(\"Installation finished. After a browser restart, you should be able to select to use this locale via Edit > Preferences (Appearance panel).\");");
            pw.println("        }");
            pw.println("        else");
            pw.println("        {");
            pw.println("            alert(\"Installation failed. Error code was \" + err);");
            pw.println("        }");
            pw.println("    }");
            pw.println("    else");
            pw.println("    {");
            pw.println("        cancelInstall(err);");
            pw.println("        logComment(\"cancelInstall due to error: \" + err);");
            pw.println("        if (err == -202) {");
            pw.println("           alert(\"Installation canceled with error \" + err +\". It seems you have no write permission to the Mozilla 'chrome' directory. Please install as root / system administrator.\");");
            pw.println("        }");
            pw.println("        else {");
            pw.println("           alert(\"Installation canceled. Error code was \" + err);");
            pw.println("        }");
            pw.println("    }");
            pw.println("}");
            pw.println("else");
            pw.println("    cancelInstall(INSUFFICIENT_DISK_SPACE);");
            pw.close();
            this.copyFile(fil, "install.js");
            fil.delete();
        }
        catch (Exception e) {
            Log.write("Error writing installScript file");
            Log.write("Exception :".concat(String.valueOf(String.valueOf(e))));
        }
    }

    private void copyFile(File tempFile, String eName) throws IOException {
        ZipEntry ze = new ZipEntry(eName);
        this.zos.putNextEntry(ze);
        FileInputStream fis = new FileInputStream(tempFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        boolean theEnd = false;
        while (!theEnd) {
            int trans = bis.read();
            if (trans == -1) {
                theEnd = true;
                continue;
            }
            this.bos.write(trans);
        }
        bis.close();
        this.bos.flush();
    }
}

