/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Settings;
import org.mozilla.translator.kernel.Utils;

public class ReadLocaleDialog
extends JDialog {
    private JPanel infPanel;
    private JLabel fileLabel;
    private JTextField fileField;
    private JButton fileButton;
    private JLabel installLabel;
    private JComboBox installCombo;
    private JLabel localeLabel;
    private JTextField localeField;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okay;

    public ReadLocaleDialog() {
        super(MainWindow.getDefaultInstance(), "import translarion from mozilla", true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        Utils.placeFrameAtCenter(this);
    }

    private void initComponents() {
        this.infPanel = new JPanel();
        this.fileLabel = new JLabel();
        this.fileField = new JTextField();
        this.fileButton = new JButton();
        this.installLabel = new JLabel();
        this.installCombo = new JComboBox<Object>(Glossary.getDefaultInstance().toArray());
        this.localeLabel = new JLabel();
        this.localeField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.infPanel.setLayout(new GridBagLayout());
        this.infPanel.setBorder(new TitledBorder(new EtchedBorder(), "Information", 4, 2, new Font("Dialog", 0, 10)));
        this.fileLabel.setText("Location");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.fileLabel, gridBagConstraints2);
        this.fileField.setColumns(20);
        this.fileField.setText("D:\\preo\\fhbndj\\hoigtrod\\glossary.zip");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.fileField, gridBagConstraints2);
        this.fileButton.setText("Choose");
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReadLocaleDialog.this.fileButtonPressed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.fileButton, gridBagConstraints2);
        this.installLabel.setText("Install");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.installLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 3, 3);
        gridBagConstraints2.anchor = 17;
        this.infPanel.add((Component)this.installCombo, gridBagConstraints2);
        this.localeLabel.setText("Locale");
        gridBagConstraints2 = new GridBagConstraints();
        this.infPanel.add((Component)this.localeLabel, gridBagConstraints2);
        this.localeField.setColumns(20);
        this.localeField.setText("jTextField1");
        gridBagConstraints2 = new GridBagConstraints();
        this.infPanel.add((Component)this.localeField, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.infPanel, gridBagConstraints1);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReadLocaleDialog.this.okButtonPressed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints1.anchor = 13;
        gridBagConstraints1.weightx = 0.5;
        this.getContentPane().add((Component)this.okButton, gridBagConstraints1);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReadLocaleDialog.this.cancelButtonPressed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(0, 0, 3, 3);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.5;
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints1);
    }

    private void fileButtonPressed(ActionEvent evt) {
        File defaultFile = new File(this.fileField.getText());
        JFileChooser dirChooser = new JFileChooser();
        dirChooser.setFileSelectionMode(2);
        dirChooser.setDialogTitle("Select locale directory or jar file to import");
        dirChooser.setSelectedFile(defaultFile);
        int result = dirChooser.showDialog(this, "Choose");
        if (result == 0) {
            File dir = dirChooser.getSelectedFile();
            this.fileField.setText(dir.toString());
        }
    }

    private void okButtonPressed(ActionEvent evt) {
        this.okay = true;
        ((Component)this).setVisible(false);
    }

    private void cancelButtonPressed(ActionEvent evt) {
        this.okay = false;
        ((Component)this).setVisible(false);
    }

    public boolean visDialog() {
        this.fileField.setText(Settings.getString("saved.fileName.locale.import", ""));
        this.localeField.setText(Settings.getString("saved.localeName", ""));
        MozInstall preSelect = (MozInstall)Glossary.getDefaultInstance().getChildByName(Settings.getString("saved.install", ""));
        if (preSelect != null) {
            this.installCombo.setSelectedItem(preSelect);
        }
        ((Component)this).setVisible(true);
        if (this.okay) {
            Settings.setString("saved.localeName", this.localeField.getText());
            Settings.setString("saved.fileName.locale.import", this.fileField.getText());
            Settings.setString("saved.install", this.installCombo.getSelectedItem().toString());
        }
        return this.okay;
    }

    public String getFile() {
        return this.fileField.getText();
    }

    public MozInstall getInstall() {
        return (MozInstall)this.installCombo.getSelectedItem();
    }

    public String getLocaleName() {
        return this.localeField.getText();
    }
}

