/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;
import org.mozilla.translator.io.MozFileWriter;
import org.mozilla.translator.kernel.Settings;

public class DTDWriter
extends MozFileWriter {
    private static String header = String.valueOf(String.valueOf(new StringBuffer("<!-- Translated with MozillaTranslator ").append(Settings.getString("System.Version", "(unknown version)")).append("  -->")));

    public DTDWriter(MozFile f, OutputStream o) {
        super(f, o);
    }

    public void writeFile(String localeName) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(this.os, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(header);
        bw.newLine();
        Iterator phraseIterator = this.fil.getChildIterator();
        while (phraseIterator.hasNext()) {
            Phrase currentPhrase = (Phrase)phraseIterator.next();
            String key = currentPhrase.getName();
            Translation currentTranslation = (Translation)currentPhrase.getChildByName(localeName);
            String text = currentTranslation == null || localeName.equals("en-us") || currentPhrase.getKeepOriginal() ? currentPhrase.getText() : currentTranslation.getText();
            String line = text.indexOf("\"") == -1 ? String.valueOf(String.valueOf(new StringBuffer("<!ENTITY ").append(key).append(" \"").append(text).append("\">"))) : String.valueOf(String.valueOf(new StringBuffer("<!ENTITY ").append(key).append(" '").append(text).append("'>")));
            bw.write(line, 0, line.length());
            bw.newLine();
        }
        bw.close();
    }
}

