/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class MozProperties
extends Properties {
    protected MozProperties defaults;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MozProperties() {
        this((MozProperties)null);
    }

    public MozProperties(MozProperties defaults) {
        this.defaults = defaults;
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            MozProperties.writeln(awriter, "#".concat(String.valueOf(String.valueOf(header))));
        }
        MozProperties.writeln(awriter, "#".concat(String.valueOf(String.valueOf(new Date().toString()))));
        Enumeration e = ((Hashtable)this).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)((Hashtable)this).get(key);
            key = this.saveConvert(key, true);
            val = this.saveConvert(val, false);
            MozProperties.writeln(awriter, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(key))).append("=").append(val))));
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar < ' ' || aChar > '~') {
                outBuffer.append('\\');
                outBuffer.append('u');
                outBuffer.append(MozProperties.toHex(aChar >> 12 & 0xF));
                outBuffer.append(MozProperties.toHex(aChar >> 8 & 0xF));
                outBuffer.append(MozProperties.toHex(aChar >> 4 & 0xF));
                outBuffer.append(MozProperties.toHex(aChar & 0xF));
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

