/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.io.MozInstallAccess;
import org.mozilla.translator.kernel.Log;

public class PartialAccess
implements MozInstallAccess {
    Object[] subcomponents;
    String fileName;
    MozInstall install;

    public PartialAccess(String fn, MozInstall i) {
        this.fileName = fn;
        this.install = i;
        this.subcomponents = null;
    }

    public PartialAccess(String fn, MozInstall i, Object[] sc) {
        this.fileName = fn;
        this.install = i;
        this.subcomponents = sc;
    }

    public void load() {
        MainWindow vindue = MainWindow.getDefaultInstance();
        try {
            vindue.setStatus("Loading file");
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(this.fileName);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            prop.load(zis);
            zis.closeEntry();
            zis.close();
            int subcomponentMax = Integer.parseInt(prop.getProperty("subcomponent.count"));
            for (int subcomponentCount = 0; subcomponentCount < subcomponentMax; ++subcomponentCount) {
                MozComponent currentSubcomponent;
                vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("Parsing subcomponent ").append(subcomponentCount + 1).append(" of ").append(subcomponentMax))));
                String subcomponentPrefix = String.valueOf(String.valueOf(new StringBuffer("").append(subcomponentCount).append(".")));
                MozComponent currentComponent = (MozComponent)this.install.getChildByName(prop.getProperty(String.valueOf(String.valueOf(subcomponentPrefix)).concat("parent")));
                if (currentComponent == null || (currentSubcomponent = (MozComponent)currentComponent.getChildByName(prop.getProperty(String.valueOf(String.valueOf(subcomponentPrefix)).concat("name")))) == null) continue;
                int fileMax = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(subcomponentPrefix)).concat("count")));
                for (int fileCount = 0; fileCount < fileMax; ++fileCount) {
                    String filePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(subcomponentPrefix))).append(fileCount).append(".")));
                    MozFile currentFile = (MozFile)currentSubcomponent.getChildByName(prop.getProperty(String.valueOf(String.valueOf(filePrefix)).concat("name")));
                    if (currentFile == null) continue;
                    int phraseMax = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(filePrefix)).concat("count")));
                    for (int phraseCount = 0; phraseCount < phraseMax; ++phraseCount) {
                        String phrasePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(filePrefix))).append(phraseCount).append(".")));
                        Phrase currentPhrase = (Phrase)currentFile.getChildByName(prop.getProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("key")));
                        if (currentPhrase == null) continue;
                        int translationMax = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("count")));
                        for (int translationCount = 0; translationCount < translationMax; ++translationCount) {
                            String translationPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(phrasePrefix))).append(translationCount).append(".")));
                            int qa_status = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(translationPrefix)).concat("status")));
                            String qa_comment = prop.getProperty(String.valueOf(String.valueOf(translationPrefix)).concat("comment"));
                            String loc_name = prop.getProperty(String.valueOf(String.valueOf(translationPrefix)).concat("name"));
                            String text = prop.getProperty(String.valueOf(String.valueOf(translationPrefix)).concat("text"));
                            Translation currentTranslation = (Translation)currentPhrase.getChildByName(loc_name);
                            if (currentTranslation == null) {
                                currentTranslation = new Translation(loc_name, currentPhrase, text, qa_status, qa_comment);
                                currentPhrase.addChild(currentTranslation);
                                continue;
                            }
                            currentTranslation.setStatus(qa_status);
                            currentTranslation.setComment(qa_comment);
                            currentTranslation.setText(text);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Log.write("Exception ".concat(String.valueOf(String.valueOf(e))));
            Log.write("Error importing glossary");
        }
        MainWindow.getDefaultInstance().setStatus("Ready");
    }

    public void save() {
        MainWindow vindue = MainWindow.getDefaultInstance();
        Properties prop = new Properties();
        int subcomponentMax = this.subcomponents.length;
        for (int subCount = 0; subCount < subcomponentMax; ++subCount) {
            vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("Parsing subcomponent ").append(subCount + 1).append(" of ").append(subcomponentMax))));
            String subPrefix = String.valueOf(String.valueOf(new StringBuffer("").append(subCount).append(".")));
            MozComponent currentSubcomponent = (MozComponent)this.subcomponents[subCount];
            MozComponent currentComponent = (MozComponent)currentSubcomponent.getParent();
            prop.setProperty(String.valueOf(String.valueOf(subPrefix)).concat("name"), currentSubcomponent.getName());
            prop.setProperty(String.valueOf(String.valueOf(subPrefix)).concat("parent"), currentComponent.getName());
            Iterator fileIterator = currentSubcomponent.getChildIterator();
            int fileCounter = 0;
            while (fileIterator.hasNext()) {
                String filePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(subPrefix))).append(fileCounter).append(".")));
                ++fileCounter;
                MozFile currentFile = (MozFile)fileIterator.next();
                prop.setProperty(String.valueOf(String.valueOf(filePrefix)).concat("name"), currentFile.getName());
                Iterator phraseIterator = currentFile.getChildIterator();
                int phraseCounter = 0;
                while (phraseIterator.hasNext()) {
                    String phrasePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(filePrefix))).append(phraseCounter).append(".")));
                    ++phraseCounter;
                    Phrase currentPhrase = (Phrase)phraseIterator.next();
                    prop.setProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("key"), currentPhrase.getName());
                    Iterator translationIterator = currentPhrase.getChildIterator();
                    int translationCounter = 0;
                    while (translationIterator.hasNext()) {
                        String translationPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(phrasePrefix))).append(translationCounter).append(".")));
                        ++translationCounter;
                        Translation currentTranslation = (Translation)translationIterator.next();
                        prop.setProperty(String.valueOf(String.valueOf(translationPrefix)).concat("name"), currentTranslation.getName());
                        prop.setProperty(String.valueOf(String.valueOf(translationPrefix)).concat("comment"), currentTranslation.getComment());
                        prop.setProperty(String.valueOf(String.valueOf(translationPrefix)).concat("status"), "".concat(String.valueOf(String.valueOf(currentTranslation.getStatus()))));
                        prop.setProperty(String.valueOf(String.valueOf(translationPrefix)).concat("text"), currentTranslation.getText());
                    }
                    prop.setProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("count"), "".concat(String.valueOf(String.valueOf(translationCounter))));
                }
                prop.setProperty(String.valueOf(String.valueOf(filePrefix)).concat("count"), "".concat(String.valueOf(String.valueOf(phraseCounter))));
            }
            prop.setProperty(String.valueOf(String.valueOf(subPrefix)).concat("count"), "".concat(String.valueOf(String.valueOf(fileCounter))));
        }
        prop.setProperty("subcomponent.count", "".concat(String.valueOf(String.valueOf(subcomponentMax))));
        try {
            vindue.setStatus("Saving file");
            FileOutputStream fos = new FileOutputStream(this.fileName);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry("glossary.txt");
            zos.putNextEntry(ze);
            prop.store(zos, "Partial glossary file for MozillaTranslator");
            zos.closeEntry();
            zos.close();
        }
        catch (Exception e) {
            Log.write("error writing partial glossary file");
        }
        vindue.setStatus("Ready");
    }
}

