/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.runners;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.io.MozFileWriter;
import org.mozilla.translator.io.MozIo;
import org.mozilla.translator.kernel.Log;

public class WriteOldXpiRunner
extends Thread {
    private MozInstall install;
    private String fileName;
    private String localeName;
    private String author;
    private String display;
    private String preview;
    private String version;
    private File zipFile;
    private FileOutputStream fos;
    private ZipOutputStream zos;
    private BufferedOutputStream bos;
    private String entryName;

    public WriteOldXpiRunner(MozInstall i, String fn, String ln, String a, String d, String p) {
        this.install = i;
        this.fileName = fn;
        this.localeName = ln;
        this.author = a;
        this.display = d;
        this.preview = p;
        this.version = "Invalid";
    }

    public void run() {
        MainWindow vindue = MainWindow.getDefaultInstance();
        int filesDone = 0;
        try {
            this.zipFile = new File(this.fileName);
            this.fos = new FileOutputStream(this.zipFile);
            this.zos = new ZipOutputStream(this.fos);
            this.bos = new BufferedOutputStream(this.zos);
            Iterator componentIterator = this.install.getChildIterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                String componentPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.localeName))).append(File.separator).append(currentComponent.getName())));
                Iterator subcomponentIterator = currentComponent.getChildIterator();
                while (subcomponentIterator.hasNext()) {
                    MozComponent currentSubComponent = (MozComponent)subcomponentIterator.next();
                    String subcomponentPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(componentPrefix))).append(File.separator).append("locale")));
                    if (!currentSubComponent.getName().equals("MT_default")) {
                        subcomponentPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(subcomponentPrefix))).append(File.separator).append(currentSubComponent.getName())));
                    }
                    Iterator fileIterator = currentSubComponent.getChildIterator();
                    while (fileIterator.hasNext()) {
                        MozFile currentFile = (MozFile)fileIterator.next();
                        this.entryName = String.valueOf(String.valueOf(new StringBuffer("bin").append(File.separator).append("chrome").append(File.separator).append("locales").append(File.separator)));
                        this.entryName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.entryName))).append(subcomponentPrefix).append(File.separator).append(currentFile.getName())));
                        vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("files done: ").append(filesDone).append(", currently packing: ").append(currentFile))));
                        this.writeFile(currentFile);
                        ++filesDone;
                    }
                }
            }
            this.writeManifest();
            this.writeInstallScript();
            this.bos.close();
        }
        catch (Exception e) {
            Log.write("Error writing xpi file");
            Log.write("Exception: ".concat(String.valueOf(String.valueOf(e))));
        }
        MainWindow.getDefaultInstance().setStatus("Ready");
    }

    private void writeFile(MozFile fil) throws IOException {
        File temp = File.createTempFile("MT_", null);
        temp.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(temp);
        MozFileWriter writer = MozIo.getFileWriter(fil, fos);
        if (writer != null) {
            writer.writeFile(this.localeName);
            this.copyFile(temp, this.entryName);
        } else {
            MozComponent subcomp = (MozComponent)fil.getParent();
            MozComponent comp = (MozComponent)subcomp.getParent();
            MozInstall install = (MozInstall)comp.getParent();
            String origFilename = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(install.getPath()))).append(File.separator).append(comp.getName())));
            origFilename = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(origFilename))).append(File.separator).append("locale")));
            if (!subcomp.getName().equals("MT_default")) {
                origFilename = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(origFilename))).append(File.separator).append(subcomp.getName())));
            }
            origFilename = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(origFilename))).append(File.separator).append(fil.getName())));
            File orig = new File(origFilename);
            this.copyFile(orig, this.entryName);
        }
    }

    private void writeManifest() {
        try {
            File fil = File.createTempFile("MT_", null);
            fil.deleteOnExit();
            FileWriter fw = new FileWriter(fil);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("<?xml version=\"1.0\"?>");
            pw.println("<RDF:RDF xmlns:RDF=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
            pw.println("         xmlns:chrome=\"http://www.mozilla.org/rdf/chrome#\">");
            pw.println();
            pw.println("  <RDF:Seq about=\"urn:mozilla:locale:root\">");
            pw.println(String.valueOf(String.valueOf(new StringBuffer("    <RDF:li resource=\"urn:mozilla:locale:").append(this.localeName).append("\"/>"))));
            pw.println("  </RDF:Seq>");
            pw.println();
            pw.println(String.valueOf(String.valueOf(new StringBuffer("  <RDF:Description about=\"urn:mozilla:locale:").append(this.localeName).append("\""))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("       chrome:displayName=\"").append(this.display).append("\""))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("       chrome:author=\"").append(this.author).append("\""))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("       chrome:name=\"").append(this.localeName).append("\""))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("       chrome:previewURL=\"").append(this.preview).append("\">"))));
            pw.println();
            pw.println("    <chrome:packages>");
            pw.println(String.valueOf(String.valueOf(new StringBuffer("      <RDF:Seq about=\"urn:mozilla:locale:").append(this.localeName).append(":packages\">"))));
            Iterator componentIterator = this.install.getChildIterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                pw.println(String.valueOf(String.valueOf(new StringBuffer("        <RDF:li resource=\"urn:mozilla:locale:").append(this.localeName).append(":").append(currentComponent.getName()).append("\"/>"))));
            }
            pw.println("      </RDF:Seq>");
            pw.println("    </chrome:packages>");
            pw.println("  </RDF:Description>");
            pw.println("</RDF:RDF>");
            pw.close();
            this.copyFile(fil, String.valueOf(String.valueOf(new StringBuffer("bin").append(File.separator).append("chrome").append(File.separator).append("locales").append(File.separator).append(this.localeName).append(File.separator).append("manifest.rdf"))));
        }
        catch (Exception e) {
            Log.write("Error writing manifest file");
        }
    }

    private void writeInstallScript() {
        try {
            File fil = File.createTempFile("MT_", null);
            fil.deleteOnExit();
            FileWriter fw = new FileWriter(fil);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("// this function verifies disk space in kilobytes");
            pw.println("function verifyDiskSpace(dirPath, spaceRequired)");
            pw.println("{");
            pw.println("\t var spaceAvailable;");
            pw.println();
            pw.println("\t // Get the available disk space on the given path");
            pw.println("\t spaceAvailable = fileGetDiskSpaceAvailable(dirPath);");
            pw.println("\t // Convert the available disk space into kilobytes");
            pw.println("\t spaceAvailable = parseInt(spaceAvailable / 1024);");
            pw.println("\t // do the verification");
            pw.println("\t if(spaceAvailable < spaceRequired)");
            pw.println("\t {");
            pw.println("\t\t logComment(\"Insufficient disk space: \" + dirPath);");
            pw.println("\t\t logComment(\"  required : \" + spaceRequired + \" K\");");
            pw.println("\t\t logComment(\"  available: \" + spaceAvailable + \" K\");");
            pw.println("\t\t return(false);");
            pw.println("\t }");
            pw.println("\t return(true);");
            pw.println("}");
            pw.println("var srDest = 643;");
            pw.println("var err;");
            pw.println("var fProgram;");
            pw.println("// --- LOCALIZATION NOTE: translate only these ---");
            pw.println(String.valueOf(String.valueOf(new StringBuffer("var prettyName = \"").append(this.display).append("\";"))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("var regName    = \"locales/mozilla/").append(this.localeName).append("\";"))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("var chromeName = \"locales/").append(this.localeName).append("\";"))));
            pw.println("// --- END LOCALIZABLE RESOURCES ---");
            pw.println("err = initInstall(prettyName, regName, \"5.0.0.0000000000\");");
            pw.println("logComment(\"initInstall: \" + err);");
            pw.println("fProgram = getFolder(\"Program\");");
            pw.println("logComment(\"fProgram: \" + fProgram);");
            pw.println("if (verifyDiskSpace(fProgram, srDest))");
            pw.println("{");
            pw.println("\t err = addDirectory(\"\",");
            pw.println("\t\t \"5.0.0.0000000000\",");
            pw.println("\t\t \"bin\",");
            pw.println("\t\t fProgram,");
            pw.println("\t\t \"\",");
            pw.println("\t\t true);");
            pw.println("\t logComment(\"addDirectory() returned: \" + err);");
            pw.println("\t // register chrome");
            pw.println("\t var cf = getFolder(\"Chrome\");");
            pw.println("\t registerChrome(LOCALE | DELAYED_CHROME, getFolder(cf, chromeName));");
            pw.println("\t if (err == SUCCESS)");
            pw.println("\t {");
            pw.println("\t err = performInstall(); ");
            pw.println("\t logComment(\"performInstall() returned: \" + err);");
            pw.println("\t }");
            pw.println("\t else");
            pw.println("\t {");
            pw.println("\t cancelInstall(err);");
            pw.println("\t logComment(\"cancelInstall due to error: \" + err);");
            pw.println("\t }");
            pw.println("}");
            pw.println("else");
            pw.println("\t cancelInstall(INSUFFICIENT_DISK_SPACE);");
            pw.close();
            this.copyFile(fil, "install.js");
        }
        catch (Exception e) {
            Log.write("Error writing installScript file");
        }
    }

    private void copyFile(File tempFile, String eName) throws IOException {
        ZipEntry ze = new ZipEntry(eName);
        this.zos.putNextEntry(ze);
        FileInputStream fis = new FileInputStream(tempFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        boolean theEnd = false;
        while (!theEnd) {
            int trans = bis.read();
            if (trans == -1) {
                theEnd = true;
                continue;
            }
            this.bos.write(trans);
        }
        bis.close();
        this.bos.flush();
    }
}

